/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.ui.swt.wizard.diskimage;

import com.webcodepro.applecommander.ui.UiBundle;
import com.webcodepro.applecommander.ui.swt.wizard.WizardPane;
import com.webcodepro.applecommander.ui.swt.wizard.diskimage.DiskImageNamePane;
import com.webcodepro.applecommander.ui.swt.wizard.diskimage.DiskImageWizard;
import com.webcodepro.applecommander.util.TextBundle;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public class DiskImageSizePane
extends WizardPane {
    private TextBundle textBundle = UiBundle.getInstance();
    private DiskImageWizard wizard;
    private Composite control;
    private Composite parent;

    public DiskImageSizePane(Composite parent, DiskImageWizard wizard) {
        this.parent = parent;
        this.wizard = wizard;
    }

    @Override
    public WizardPane getNextPane() {
        return new DiskImageNamePane(this.parent, this.wizard);
    }

    @Override
    public void open() {
        this.control = new Composite(this.parent, 0);
        this.wizard.enableNextButton(true);
        this.wizard.enableFinishButton(false);
        RowLayout layout = new RowLayout(512);
        layout.justify = true;
        layout.marginBottom = 5;
        layout.marginLeft = 5;
        layout.marginRight = 5;
        layout.marginTop = 5;
        layout.spacing = 3;
        this.control.setLayout(layout);
        Label label = new Label(this.control, 64);
        label.setText(this.textBundle.get("DiskImageSizePrompt"));
        RowLayout subpanelLayout = new RowLayout(512);
        subpanelLayout.justify = true;
        subpanelLayout.spacing = 3;
        Composite buttonSubpanel = new Composite(this.control, 0);
        buttonSubpanel.setLayout(subpanelLayout);
        this.createRadioButton(buttonSubpanel, this.textBundle.get("DiskImageSize140Kb"), 143360, this.textBundle.get("DiskImageSize140KbText"));
        this.createRadioButton(buttonSubpanel, this.textBundle.get("DiskImageSize800Kb"), 819264, this.textBundle.get("DiskImageSize800KbText"));
        if (this.wizard.getFormat() == 3) {
            this.createRadioButton(buttonSubpanel, this.textBundle.get("DiskImageSize5Mb"), 0x500000, this.textBundle.get("DiskImageSize5MbText"));
            this.createRadioButton(buttonSubpanel, this.textBundle.get("DiskImageSize10Mb"), 0xA00000, this.textBundle.get("DiskImageSize10MbText"));
            this.createRadioButton(buttonSubpanel, this.textBundle.get("DiskImageSize20Mb"), 0x1400000, this.textBundle.get("DiskImageSize20MbText"));
            this.createRadioButton(buttonSubpanel, this.textBundle.get("DiskImageSize32Mb"), 33553920, this.textBundle.get("DiskImageSize32MbText"));
        }
    }

    protected void createRadioButton(Composite composite, String label, final int size, String helpText) {
        Button button = new Button(composite, 16);
        button.setText(label);
        button.setToolTipText(helpText);
        button.setSelection(this.wizard.getSize() == size);
        button.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                DiskImageSizePane.this.getWizard().setSize(size);
            }
        });
    }

    @Override
    public void dispose() {
        this.control.dispose();
    }

    protected DiskImageWizard getWizard() {
        return this.wizard;
    }
}

